<?php
/**
 * The template to display Admin notices
 *
 * @package FOODIE
 * @since FOODIE 1.0.64
 */

$foodie_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$foodie_skins_args = get_query_var( 'foodie_skins_notice_args' );
?>
<div class="foodie_admin_notice foodie_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$foodie_theme_img = foodie_get_file_url( 'screenshot.jpg' );
	if ( '' != $foodie_theme_img ) {
		?>
		<div class="foodie_notice_image"><img src="<?php echo esc_url( $foodie_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'foodie' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="foodie_notice_title">
		<?php esc_html_e( 'New skins available', 'foodie' ); ?>
	</h3>
	<?php

	// Description
	$foodie_total      = $foodie_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$foodie_skins_msg  = $foodie_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $foodie_total, 'foodie' ), $foodie_total ) . '</strong>'
							: '';
	$foodie_total      = $foodie_skins_args['free'];
	$foodie_skins_msg .= $foodie_total > 0
							? ( ! empty( $foodie_skins_msg ) ? ' ' . esc_html__( 'and', 'foodie' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $foodie_total, 'foodie' ), $foodie_total ) . '</strong>'
							: '';
	$foodie_total      = $foodie_skins_args['pay'];
	$foodie_skins_msg .= $foodie_skins_args['pay'] > 0
							? ( ! empty( $foodie_skins_msg ) ? ' ' . esc_html__( 'and', 'foodie' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $foodie_total, 'foodie' ), $foodie_total ) . '</strong>'
							: '';
	?>
	<div class="foodie_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'foodie' ), $foodie_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="foodie_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $foodie_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'foodie' );
			?>
		</a>
	</div>
</div>
