<?php

/**
 * @package Auto-Install Free SSL
 * This package is a WordPress Plugin. It issues and installs free SSL certificates in cPanel shared hosting with complete automation.
 *
 * @author Free SSL Dot Tech <support@freessl.tech>
 * @copyright  Copyright (C) 2019-2020, Anindya Sundar Mandal
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License, version 3
 * @link       https://freessl.tech
 * @since      Class available since Release 3.0.0
 *
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
namespace AutoInstallFreeSSL\FreeSSLAuto\Admin;

use  AutoInstallFreeSSL\FreeSSLAuto\Acme\Factory as AcmeFactory ;
use  AutoInstallFreeSSL\FreeSSLAuto\Email ;
use  Exception ;
/**
 * Home page options
 *
 */
class AdminNotice
{
    public  $factory ;
    public  $options ;
    public  $acmeFactory ;
    /**
     * Start up
     */
    public function __construct()
    {
        if ( !defined( 'ABSPATH' ) ) {
            die( __( "Access Denied", 'auto-install-free-ssl' ) );
        }
        // Set class property
        $this->options = ( get_option( 'basic_settings_auto_install_free_ssl' ) ? get_option( 'basic_settings_auto_install_free_ssl' ) : add_option( 'basic_settings_auto_install_free_ssl' ) );
        $this->factory = new Factory();
        /*
         * Review display option @since 1.1.0
         *
         */
        
        if ( isset( $this->options['homedir'] ) ) {
            //initialize the Acme Factory class
            $this->acmeFactory = new AcmeFactory( $this->options['homedir'] . '/' . $this->options['certificate_directory'], $this->options['acme_version'], $this->options['is_staging'] );
            //get the path of SSL files
            $certificates_directory = $this->acmeFactory->getCertificatesDir();
            
            if ( is_dir( $certificates_directory ) ) {
                //get the domains for which SSL is present in the certificate directory
                $all_domains = $this->factory->getExistingSslList( $certificates_directory );
                //If at least one SSL cert exists in the $certificates_directory, set 'aifs_display_review' = 1 if this option doesn't exist
                if ( count( $all_domains ) > 0 ) {
                    
                    if ( strlen( get_option( 'aifs_display_review' ) ) === 0 ) {
                        //!get_option('aifs_display_review')
                        
                        if ( aifs_is_free_version() ) {
                            //Display review if a valid SSL installed -> this may slowdown a bit
                            //$display_review = $this->factory->is_ssl_installed_on_this_website() === true;
                            $display_review = true;
                        } else {
                            //Premium version. So, display review on cPanel only and if a valid SSL installed
                            //$display_review = $this->factory->is_cpanel() && $this->factory->is_ssl_installed_on_this_website() === true;
                            $display_review = $this->factory->is_cpanel();
                        }
                        
                        if ( $display_review ) {
                            add_option( 'aifs_display_review', 1 );
                        }
                    }
                
                }
            }
        
        }
        
        
        if ( is_admin() ) {
            add_action( 'admin_notices', array( $this, 'aifs_display_admin_notice' ) );
        } else {
            //add_action( 'init', array( $this, 'aifs_display_admin_notice' ) );//Send the email even if the frontend page loaded : Not working
        }
        
        add_action( 'admin_init', array( $this, 'aifs_admin_notice_handler' ) );
        /*
         * Announcement display option @since 2.2.2
         *
         */
        if ( !get_option( 'aifs_display_free_premium_offer' ) ) {
            add_option( 'aifs_display_free_premium_offer', 1 );
        }
    }
    
    /**
     *
     *
     * Display Admin notice
     *
     * @throws Exception
     * @since 2.1.1
     */
    public function aifs_display_admin_notice()
    {
        $display_review_request = true;
        $cpanel_password_missing = false;
        $dns_api_credential_missing = false;
        
        if ( isset( $this->options['homedir'] ) ) {
            $counter = (int) get_option( 'aifs_admin_notice_display_counter' );
            /*if(aifs_is_free_version()) {
               aifs_is_existing_user(); //Calling to detect existing users and send their information to FreeSSL.tech server
              }*/
            
            if ( aifs_is_free_version() ) {
                if ( isset( $_GET['page'] ) && $_GET['page'] == "auto_install_free_ssl" ) {
                    return;
                }
                
                if ( $counter % 3 == 0 ) {
                    $this->aifs_display_review_request( $display_review_request );
                } else {
                    /*
                     * Display announcement only if 'aifs_display_review' exists,
                     * i.e., at least one SSL cert issued
                     */
                    //if ( get_option( 'aifs_display_review' ) !== false ) {
                    $this->aifs_display_announcement();
                    //}
                }
            
            } else {
                if ( isset( $_GET['page'] ) && $_GET['page'] == "aifs_issue_free_ssl" ) {
                    return;
                }
                
                if ( $counter % 2 == 0 ) {
                    $this->aifs_display_review_request( true );
                } else {
                }
            
            }
            
            $this->aifs_admin_notice_display_counter();
        }
        
        //Display SSL renewal reminder
        if ( aifs_is_free_version() ) {
            $this->aifs_display_ssl_renewal_reminder();
        }
    }
    
    /**
     * Display SSL renewal reminder with admin notice
     *
     */
    public function aifs_display_ssl_renewal_reminder()
    {
        if ( isset( $_GET['page'] ) && $_GET['page'] == "aifs_generate_ssl_manually" ) {
            return;
        }
        $remind_later_interval_sec = 3 * 24 * 60 * 60;
        //3 days
        if ( time() < (int) get_option( 'aifs_renew_ssl_later_requested_timestamp' ) + $remind_later_interval_sec ) {
            return;
        }
        $home = new HomeOptions();
        $certificate = $home->single_domain_get_ssl_file_path();
        
        if ( $certificate ) {
            $cert_array = openssl_x509_parse( openssl_x509_read( file_get_contents( $certificate ) ) );
            $expiry_timestamp = $cert_array['validTo_time_t'];
            $days_before_expiry_to_renew_ssl = 30;
            //@todo correct this value
            //$expiry_date = str_replace('-', 'at', wp_date('F j, Y - h:i:s A', $expiry_timestamp));
            $expiry_date = ( function_exists( 'wp_date' ) ? wp_date( 'F j, Y', $expiry_timestamp ) : date( 'F j, Y', $expiry_timestamp ) . " " . __( "UTC", 'auto-install-free-ssl' ) );
            $issuerShort = $cert_array['issuer']['O'];
            $renewal_timestamp = $expiry_timestamp - $days_before_expiry_to_renew_ssl * 24 * 60 * 60;
            
            if ( time() > $renewal_timestamp ) {
                $renew_url = menu_page_url( 'aifs_generate_ssl_manually', false );
                $remind_later = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_renew_ssl_later', 'aifsrenewssllater' );
                $generate_ssl = new GenerateSSLmanually();
                $renew_button_text = __( 'Renew SSL Now', 'auto-install-free-ssl' );
                $html = '<div class="notice notice-error aifs-review">
	                        <div class="aifs-review-box">
	                          <img class="aifs-notice-img-left" src="' . AIFS_URL . 'assets/img/ssl-error.jpg" />
	                          <p style="text-align: justify;">' . __( 'Hello', 'auto-install-free-ssl' ) . ' ' . aifs_admin_first_name() . ', <span style="color: red;">' . __( "your visitors will see a security warning in red and may leave your website if you don't renew the SSL certificate before the expiry date", 'auto-install-free-ssl' ) . " " . $expiry_date . '.</span> <span style="font-size: small;">(' . sprintf( __( "Validity of %s free SSL is 90 days. They recommend renewing 30 days prior to expiry.", 'auto-install-free-ssl' ), $issuerShort ) . ')</span><!-- <br /><strong>~' . AIFS_NAME . '</strong>--></p>
	                        </div>
	                        <div style="margin-left: 8%; margin-top: -1%; margin-bottom: -2%;">
	                        	' . $generate_ssl->regenerate_ssl_form( $renew_button_text, true ) . '
	                        	<!-- <a class="aifs-review-now aifs-review-button" href="' . $renew_url . '">' . __( 'Renew SSL Now', 'auto-install-free-ssl' ) . '</a> -->
	                        	<span style="margin-left: 35%; position: relative; top: -25px;"><a class="aifs-review-button" href="' . $remind_later . '" rel="nofollow" onclick="return confirm(\'Are you sure you want to be reminded later to renew your SSL certificate?\')">' . __( 'Remind later', 'auto-install-free-ssl' ) . '</a></span>
	                      	</div>
	                      </div>';
                echo  $html ;
            }
        
        }
    
    }
    
    /**
     *
     *
     * Display review request
     *
     * @param $display_review_request
     *
     * @since 1.1.0
     */
    public function aifs_display_review_request( $display_review_request )
    {
        $display_review = get_option( 'aifs_display_review' );
        //Get the value of aifs_display_review
        
        if ( $display_review_request && $display_review == 1 ) {
            $already_done = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_reviewed', 'aifsrated' );
            $remind_later = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_review_later', 'aifslater' );
            $html = '<div class="notice notice-success aifs-review">
                        <div class="aifs-review-box">
                          <img class="aifs-notice-img-left" src="' . AIFS_URL . 'assets/img/icon.jpg" />
                          <p>' . __( 'Hey', 'auto-install-free-ssl' ) . ' ' . aifs_admin_first_name() . ', <strong>' . AIFS_NAME . '</strong> ' . __( 'has saved your $$$ by providing Free SSL Certificates and will save more. Could you please do me a BIG favor and give it a 5-star rating on WordPress? To help me spread the word and boost my motivation.', 'auto-install-free-ssl' ) . ' <br />~Anindya</p>
                        </div>
                        <a class="aifs-review-now aifs-review-button" href="https://wordpress.org/support/plugin/auto-install-free-ssl/reviews/#new-post" target="_blank">' . __( 'Sure! You Deserve It.', 'auto-install-free-ssl' ) . '</a>
                        <a class="aifs-review-button" href="' . $already_done . '" rel="nofollow" onclick="return confirm(\'Are you sure you have reviewed ' . AIFS_NAME . ' plugin?\')">' . __( 'I have done', 'auto-install-free-ssl' ) . '</a>
                        <a class="aifs-review-button" href="' . $already_done . '" rel="nofollow" onclick="return confirm(\'Are you sure you do NOT want to review ' . AIFS_NAME . ' plugin?\')">' . __( "I don't want to", 'auto-install-free-ssl' ) . '</a>
                        <a class="aifs-review-button" href="' . $remind_later . '" rel="nofollow" onclick="return confirm(\'Are you sure you need ' . AIFS_NAME . ' to remind you later?\')">' . __( 'Remind me later', 'auto-install-free-ssl' ) . '</a>
                      </div>';
            echo  $html ;
        }
    
    }
    
    /**
     *
     *
     * Display announcement
     *
     * @since 2.2.2
     */
    public function aifs_display_announcement()
    {
        //Get the value of aifs_display_free_premium_offer
        $display_announcement = get_option( 'aifs_display_free_premium_offer' );
        
        if ( $display_announcement == 1 ) {
            $already_done = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_announcement_already_read', 'aifsannouncementdone' );
            $remind_later = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_announcement_read_later', 'aifsannouncementlater' );
            
            if ( aifs_is_existing_user() ) {
                $link = menu_page_url( 'auto_install_free_ssl', false );
                $link_text = __( 'Claim for FREE', 'auto-install-free-ssl' );
                $already_done_text = __( 'I have already claimed', 'auto-install-free-ssl' );
                $dont_want_text = __( "I don't want it", 'auto-install-free-ssl' );
                $already_done_confirmation_text = __( 'Are you sure you have already claimed the Premium Version of', 'auto-install-free-ssl' ) . ' ' . AIFS_NAME . ' ' . __( 'for FREE?', 'auto-install-free-ssl' );
                $dont_want_confirmation_text = __( "Are you sure you do NOT want the Premium Version of", 'auto-install-free-ssl' ) . ' ' . AIFS_NAME . ' ' . __( 'for FREE?', 'auto-install-free-ssl' );
            } else {
                $link = menu_page_url( 'auto_install_free_ssl', false ) . "&comparison=yes";
                $link_text = __( 'Comparison Table', 'auto-install-free-ssl' );
                $already_done_text = __( 'Got it', 'auto-install-free-ssl' );
                $dont_want_text = __( "I don't want to", 'auto-install-free-ssl' );
                $already_done_confirmation_text = __( 'Are you sure you know the benefits of the Premium Version of', 'auto-install-free-ssl' ) . ' ' . AIFS_NAME . ' ' . __( 'compared to the free version?', 'auto-install-free-ssl' );
                $dont_want_confirmation_text = __( "Are you sure you do NOT want to learn the benefits of the Premium Version of", 'auto-install-free-ssl' ) . ' ' . AIFS_NAME . ' ' . __( 'compared to the free version?', 'auto-install-free-ssl' );
            }
            
            $html = '<div class="notice notice-success aifs-review">
                    <div class="aifs-review-box">                      
                      <p style="line-height: 1.9em;">' . __( 'Hello', 'auto-install-free-ssl' ) . ' ' . aifs_admin_first_name() . ', ';
            //$html .= '<span style="">';
            if ( aifs_is_existing_user() ) {
                $html .= '<a href="' . $link . '">' . __( 'click here', 'auto-install-free-ssl' ) . '</a> ' . __( 'and claim a Premium License of', 'auto-install-free-ssl' ) . ' <strong>' . AIFS_NAME . '</strong> ' . __( 'for FREE!', 'auto-install-free-ssl' ) . '<br />';
            }
            $html .= __( "As per our announcement dated November 3, 2020, we have released the premium version", 'auto-install-free-ssl' );
            if ( !aifs_is_existing_user() ) {
                $html .= ' ' . __( 'of', 'auto-install-free-ssl' ) . ' <strong>' . AIFS_NAME . '</strong>';
            }
            $html .= __( ", which is fully automated and this free version doesn't have any automation feature.", 'auto-install-free-ssl' ) . '</p>';
            $html .= '<img class="aifs-notice-img-right" src="' . AIFS_URL . 'assets/img/icon.jpg" />
                    </div>
                    <a class="aifs-review-now aifs-review-button" href="' . $link . '">' . $link_text . '</a>
                    <a class="aifs-review-button" href="' . $already_done . '" rel="nofollow" onclick="return confirm(\'' . $already_done_confirmation_text . '\')">' . $already_done_text . '</a>
                    <a class="aifs-review-button" href="' . $already_done . '" rel="nofollow" onclick="return confirm(\'' . $dont_want_confirmation_text . '\')">' . $dont_want_text . '</a>
                    <a class="aifs-review-button" href="' . $remind_later . '" rel="nofollow" onclick="return confirm(\'Are you sure you need ' . AIFS_NAME . ' to remind you later?\')">' . __( 'Remind me later', 'auto-install-free-ssl' ) . '</a>                                      
                    </div>';
            echo  $html ;
        }
    
    }
    
    /**
     *
     *
     * Execute admin notice actions
     *
     * @since 1.1.0 (renamed since 2.2.2)
     */
    public function aifs_admin_notice_handler()
    {
        //Review
        
        if ( isset( $_GET['aifsrated'] ) ) {
            if ( !wp_verify_nonce( $_GET['aifsrated'], 'aifs_reviewed' ) ) {
                wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
            }
            update_option( 'aifs_display_review', 0 );
            wp_redirect( $this->factory->aifs_remove_parameters_from_url( get_site_url() . $_SERVER['REQUEST_URI'], [ 'aifsrated' ] ) );
        } else {
            
            if ( isset( $_GET['aifslater'] ) ) {
                if ( !wp_verify_nonce( $_GET['aifslater'], 'aifs_review_later' ) ) {
                    wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
                }
                update_option( 'aifs_display_review', 5 );
                wp_schedule_single_event( strtotime( "+5 days", time() ), 'aifs_display_review_init' );
                wp_redirect( $this->factory->aifs_remove_parameters_from_url( get_site_url() . $_SERVER['REQUEST_URI'], [ 'aifslater' ] ) );
            }
        
        }
        
        //Announcement
        
        if ( isset( $_GET['aifsannouncementdone'] ) ) {
            if ( !wp_verify_nonce( $_GET['aifsannouncementdone'], 'aifs_announcement_already_read' ) ) {
                wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
            }
            update_option( 'aifs_display_free_premium_offer', 0 );
            wp_redirect( $this->factory->aifs_remove_parameters_from_url( get_site_url() . $_SERVER['REQUEST_URI'], [ 'aifsannouncementdone' ] ) );
        } else {
            
            if ( isset( $_GET['aifsannouncementlater'] ) ) {
                if ( !wp_verify_nonce( $_GET['aifsannouncementlater'], 'aifs_announcement_read_later' ) ) {
                    wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
                }
                update_option( 'aifs_display_free_premium_offer', 5 );
                wp_schedule_single_event( strtotime( "+3 days", time() ), 'aifs_display_announcement_init' );
                wp_redirect( $this->factory->aifs_remove_parameters_from_url( get_site_url() . $_SERVER['REQUEST_URI'], [ 'aifsannouncementlater' ] ) );
            }
        
        }
        
        //SSL Renewal reminder
        
        if ( isset( $_GET['aifsrenewssllater'] ) ) {
            if ( !wp_verify_nonce( $_GET['aifsrenewssllater'], 'aifs_renew_ssl_later' ) ) {
                wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
            }
            update_option( 'aifs_renew_ssl_later_requested_timestamp', time() );
            wp_redirect( $this->factory->aifs_remove_parameters_from_url( get_site_url() . $_SERVER['REQUEST_URI'], [ 'aifsrenewssllater' ] ) );
        }
    
    }
    
    /**
     *
     *
     * Admin notice display counter. Required to display more than one admin notices alternately
     *
     * @since 2.2.2
     */
    public function aifs_admin_notice_display_counter()
    {
        
        if ( !get_option( 'aifs_admin_notice_display_counter' ) ) {
            add_option( 'aifs_admin_notice_display_counter', 1 );
        } else {
            $counter = ( get_option( 'aifs_admin_notice_display_counter' ) < 99999999 ? get_option( 'aifs_admin_notice_display_counter' ) : 0 );
            //if equal to 99999999, reset to 0
            update_option( 'aifs_admin_notice_display_counter', $counter + 1 );
        }
    
    }

}