<?php

/**
 * @package Auto-Install Free SSL
 * This package is a WordPress Plugin. It issues and installs free SSL certificates in cPanel shared hosting with complete automation.
 *
 * @author Free SSL Dot Tech <support@freessl.tech>
 * @copyright  Copyright (C) 2019-2020, Anindya Sundar Mandal
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License, version 3
 * @link       https://freessl.tech
 * @since      Class available since Release 1.0.0
 *
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
namespace AutoInstallFreeSSL\FreeSSLAuto\Admin;

use  AutoInstallFreeSSL\FreeSSLAuto\Acme\Factory as AcmeFactory ;
/**
 * Home page options
 *
 */
class HomeOptions
{
    public  $factory ;
    public  $app_settings ;
    /**
     * Start up
     */
    public function __construct()
    {
        if ( !defined( 'ABSPATH' ) ) {
            die( __( "Access Denied", 'auto-install-free-ssl' ) );
        }
        $this->factory = new Factory();
        $this->app_settings = aifs_get_app_settings();
    }
    
    /**
     *
     *
     * Previous __construct()
     */
    public function display()
    {
        if ( aifs_is_free_version() ) {
            
            if ( aifs_is_existing_user() ) {
                //Display free Premium License request button
                $this->request_free_premium_license();
            } else {
                
                if ( !get_option( 'aifs_free_plan_selected' ) || isset( $_GET['comparison'] ) && $_GET['comparison'] == "yes" ) {
                    $this->plan_comparison_table_handler();
                    $this->plan_comparison_table();
                } else {
                    wp_redirect( admin_url( 'admin.php?page=aifs_generate_ssl_manually' ) );
                }
            
            }
        
        }
        //This will be displayed after purchase
        if ( aifssl_fs()->is_paying() && !aifssl_fs()->is_premium() ) {
            $this->after_making_payment();
        }
    }
    
    /**
     *
     * @return false|string
     */
    public function single_domain_get_ssl_file_path()
    {
        $app_settings = aifs_get_app_settings();
        $domain = aifs_get_domain( true );
        $serveralias = 'www.' . $domain;
        //initialize the Acme Factory class
        $acmeFactory = new AcmeFactory( $app_settings['homedir'] . '/' . $app_settings['certificate_directory'], $app_settings['acme_version'], $app_settings['is_staging'] );
        //get the path of SSL files
        $certificates_directory = $acmeFactory->getCertificatesDir();
        //echo $certificates_directory."<br />";
        $certificate = false;
        
        if ( is_file( $certificates_directory . DS . $domain . DS . 'certificate.pem' ) ) {
            $certificate = $certificates_directory . DS . $domain . DS . 'certificate.pem';
        } elseif ( is_file( $certificates_directory . DS . $serveralias . DS . 'certificate.pem' ) ) {
            $certificate = $certificates_directory . DS . $serveralias . DS . 'certificate.pem';
        }
        
        return $certificate;
    }
    
    /**
     *
     *
     * @return string
     */
    public function single_domain_ssl_data()
    {
        $app_settings = aifs_get_app_settings();
        $text_display = "";
        $certificate = $this->single_domain_get_ssl_file_path();
        
        if ( $certificate ) {
            $cert_array = openssl_x509_parse( openssl_x509_read( file_get_contents( $certificate ) ) );
            /*$date = new DateTime('@' . $cert_array['validTo_time_t']);
              $expiry_date = $date->format('Y-m-d H:i:s') . ' ' . date_default_timezone_get();*/
            $exp = ( function_exists( 'wp_date' ) ? wp_date( 'F j, Y - h:i:s A', $cert_array['validTo_time_t'] ) : date( 'F j, Y - h:i:s A', $cert_array['validTo_time_t'] ) . " " . __( "UTC", 'auto-install-free-ssl' ) );
            $expiry_date = str_replace( '-', 'at', $exp );
            $issuerShort = $cert_array['issuer']['O'];
            //$subjectAltName = str_replace('DNS:', '', $cert_array['extensions']['subjectAltName']);
            if ( $_GET['page'] == "auto_install_free_ssl" ) {
                $text_display .= '<h3 style="color: #0b9e0b;">https://' . aifs_get_domain() . '</h3><br />';
            }
            $text_display .= __( "SSL Expiry date", 'auto-install-free-ssl' ) . ': ' . $expiry_date . '<br />';
            $text_display .= __( "Issuer", 'auto-install-free-ssl' ) . ': ' . $issuerShort . '<br />';
            
            if ( aifs_is_free_version() ) {
                $text_display .= '<br /><strong><s>' . sprintf( __( "This plugin will renew & install the SSL automatically %s days before the expiry.", 'auto-install-free-ssl' ), 30 ) . '</s></strong>';
                $text_display .= '<br /><div class="aifs-premium"><span class="dashicons dashicons-arrow-up-alt"></span> ' . sprintf( __( "Upgrade to %sPremium Version%s to avail this.", 'auto-install-free-ssl' ), '<a href="' . admin_url( 'admin.php?page=auto_install_free_ssl-pricing' ) . '">', '</a>' ) . ' <span class="dashicons dashicons-arrow-up-alt"></span></div>';
            }
            
            //echo 'Home directory: '.$this->factory->set_ssl_parent_directory().'<br />';
            $text_display .= '<br /><hr />';
            
            if ( aifs_is_free_version() || !aifs_can_manage_multi_domain() ) {
                $certificate = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_download_ssl', 'aifsdownloadssl' ) . "&domain=" . aifs_get_domain( true );
                $text_display .= '<span class="dashicons dashicons-download" style="color: darkviolet;"></span>&nbsp;<span style="font-size: large; font-weight: bold; color: darkviolet;">' . __( "Downloads", 'auto-install-free-ssl' ) . '</span><br />';
                $text_display .= '<div class="aifs-download"><a href="' . $certificate . '&file=certificate.pem" title="' . __( "Click here to download SSL Certificate", 'auto-install-free-ssl' ) . '">' . __( "SSL", 'auto-install-free-ssl' ) . '</a> &nbsp;&nbsp;&nbsp;| &nbsp;&nbsp;&nbsp;';
                $text_display .= '<a href="' . $certificate . '&file=private.pem" title="' . __( "Click here to download Private Key", 'auto-install-free-ssl' ) . '">' . __( "Private Key", 'auto-install-free-ssl' ) . '</a> &nbsp;&nbsp;&nbsp;| &nbsp;&nbsp;&nbsp;';
                $text_display .= '<a href="' . $certificate . '&file=cabundle.pem" title="' . __( "Click here to download CA Bundle", 'auto-install-free-ssl' ) . '">' . __( "CA Bundle", 'auto-install-free-ssl' ) . '</a></div>';
                $text_display .= '<hr />';
            }
            
            
            if ( aifs_is_free_version() && !get_option( 'aifs_force_ssl' ) ) {
                $text_display .= __( "After installing the SSL certificate, don't forget to", 'auto-install-free-ssl' ) . " ";
                $text_display .= "<a href='#force-https'>" . __( "Activate Force HTTPS", 'auto-install-free-ssl' ) . "</a>";
                $text_display .= "<hr />";
            }
        
        }
        
        return $text_display;
    }
    
    /**
     * Handles free Premium License request
     *
     */
    private function request_free_premium_license()
    {
        if ( !aifs_is_existing_user() ) {
            return;
        }
        $response = [];
        $options = ( get_option( 'aifs_request_free_premium_license' ) ? get_option( 'aifs_request_free_premium_license' ) : add_option( 'aifs_request_free_premium_license' ) );
        //if (isset($_GET['settings-updated']) && $_GET['settings-updated'] === 'true') {
        
        if ( 'POST' === $_SERVER['REQUEST_METHOD'] && isset( $_POST['agree_to_freessl_tech_tos_pp'] ) ) {
            //request license
            //Send domain, admin name and email to FreeSSL.tech server
            $admin_email = get_option( 'admin_email' );
            $admin = get_user_by( 'email', $admin_email );
            //$admin->first_name;
            global  $wp_version ;
            $data = array(
                'body' => array(
                'domain'               => aifs_get_domain( true ),
                'admin_email'          => $admin_email,
                'key'                  => "xX4x0;58CVl3[0~+f[*pH8c*Vg_7ioiKR-69zu~F8itU2(md@8eT5[7J22R7*5&(",
                'admin_first_name'     => $admin->first_name,
                'admin_last_name'      => $admin->last_name,
                'aifs_version'         => AIFS_VERSION,
                'wordpress_version'    => $wp_version,
                'is_free_version'      => aifs_is_free_version(),
                'is_premium'           => aifssl_fs()->is_premium(),
                'can_use_premium_code' => aifssl_fs()->can_use_premium_code(),
                'ip_server'            => $_SERVER['SERVER_ADDR'],
                'ip_user'              => $_SERVER['REMOTE_ADDR'],
            ),
            );
            //Send the request to freessl.tech
            $response = wp_remote_post( "https://pro.freessl.tech/aifs_request_free.php", $data );
            
            if ( $response['response']['code'] === 200 ) {
                $class = "notice-success";
                $font_size = 8;
                $color = "green";
            } else {
                $class = "notice-error";
                $color = "red";
                $font_size = 8;
            }
            
            //if($response['response']['code'] === 200) {
            //echo "<pre>";
            echo  "<br /><br />" ;
            echo  '<div class="notice ' . $class . ' is-dismissible">' ;
            echo  '<span class="dashicons dashicons-info-outline" style="font-size: ' . $font_size . 'em; color: ' . $color . '; float: right; margin-top: 1%; margin-right: 10%;"></span>' ;
            echo  $response['body'] ;
            echo  '</div>' ;
            //echo "</pre>";
            //}
            $options[] = array(
                'agree_to_freessl_tech_tos_pp' => true,
                'sent'                         => $data,
                'received'                     => $response['body'],
            );
            update_option( 'aifs_request_free_premium_license', $options );
        }
        
        ?>
        <div class="wrap">

        <?php 
        echo  aifs_header() ;
        ?>

        <table style="width: 100%; margin-bottom: 2%;">
            <tr>
                <td class="card block-body" style="width: 55%; padding-top: 1%; padding-left: 2%;">

				    <?php 
        $heading = __( "Claim Premium License for FREE", 'auto-install-free-ssl' );
        echo  '<h1 style="color: #076507; text-align: center;">' . $heading . '</h1>' ;
        echo  '<br /><h3 style="color: #076507; text-align: center; margin-top: -0.1%;">' . __( "Exclusive offer for the Existing users", 'auto-install-free-ssl' ) . '</h3>' ;
        echo  '<p style="color: #000000; text-align: center; margin-top: -0.1%;">' . __( "The FREE license is valid until December 31, 2022", 'auto-install-free-ssl' ) . '</p>' ;
        echo  '<p style="color: #000000; text-align: center;">' . __( "Unlimited Sites license", 'auto-install-free-ssl' ) . '</p>' ;
        $save_button_text = __( "Request Premium License for Free", 'auto-install-free-ssl' );
        
        if ( !isset( $response['response']['code'] ) || $response['response']['code'] != 200 ) {
            $tos_text = __( "By clicking the '%s' button you acknowledge that you agree with FreeSSL.tech %s & %s.", 'auto-install-free-ssl' );
            $fs_tos = '<a href="https://freessl.tech/terms-of-service" target="_blank">' . __( "Terms of Service", 'auto-install-free-ssl' ) . '</a>';
            $fs_pp = '<a href="https://freessl.tech/privacy-policy" target="_blank">' . __( "Privacy Policy", 'auto-install-free-ssl' ) . '</a>';
            echo  "<p><br />" . sprintf(
                $tos_text,
                $save_button_text,
                $fs_pp,
                $fs_tos
            ) . "<br /><br /></p>" ;
            echo  '<form method="post" action="">' ;
            /*settings_fields( 'aifs_generate_ssl_manually_group' );
              do_settings_sections( 'aifs_generate_ssl_manually_admin' );*/
            $confirmation_text = __( "Are you sure to request FREE Premium License?", 'auto-install-free-ssl' );
            submit_button(
                $save_button_text,
                'button-primary button-hero',
                'agree_to_freessl_tech_tos_pp',
                false,
                'onclick="return aifs_confirm(\'' . $confirmation_text . '\')"'
            );
            //echo '<a href="' . menu_page_url( 'auto_install_free_ssl', false ) . '" id="aifs-cancel" class="page-title-action button">' . __( "Cancel", 'auto-install-free-ssl' ) . '</a>';
            echo  '</form>' ;
        }
        
        ?>


                </td>

                <td style="width: 2%;"></td>

                <td class="card block-body" style="width: 43%; padding-top: 1%; padding-left: 2%;">
                    <h3 class="block-title"><?php 
        echo  __( "How to Claim & Activate the Premium Version", 'auto-install-free-ssl' ) ;
        ?></h3>
                    <p style="color: green;"><?php 
        echo  __( "Video tutorial. Time required: 1 minute.", 'auto-install-free-ssl' ) ;
        ?></p>

                    <iframe width="100%" height="281" src="https://www.youtube.com/embed/wLG8fT3AFqE?start=46" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </td>

			    <?php 
        /*$forcehttps = new ForceSSL();
          echo $forcehttps->force_ssl_ui();*/
        ?>
            </tr>

        </table>

        <div class="overlay"></div>
        <div class="spanner">
            <div class="loader"></div>
            <p class="loader_text"><?php 
        echo  __( "Processing, please wait ...", 'auto-install-free-ssl' ) ;
        ?></p>
        </div>

        <?php 
        $manually = new GenerateSSLmanually();
        $manually->pro_version_promotion();
        ?>
        <?php 
        echo  aifs_powered_by() ;
        ?>
        </div>
    <?php 
    }
    
    /**
     * Display plan comparison table
     * @since 3.0.6
     */
    public function plan_comparison_table()
    {
        $app_settings = aifs_get_app_settings();
        ?>
        <div class="wrap">

        <?php 
        echo  aifs_header() ;
        ?>

        <?php 
        
        if ( $this->factory->is_cpanel() && (get_option( 'aifs_premium_plan_selected' ) >= 1 && time() < strtotime( "January 1, 2023" ) || time() > strtotime( "November 1, 2022" ) && time() < strtotime( "December 1, 2022" )) ) {
            echo  '<div style="background: white; color: black; margin: 2% 0; padding: 1% 1.5%; border-style: solid; border-width: 1px; border-color: green;"><p style="font-size: medium; margin: 0;">' ;
            echo  '<span class="dashicons dashicons-megaphone" style="font-size: xx-large; color: #5F97FB;"></span> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . sprintf(
                __( "Could a coupon help? Use the %s discount%s code %s during checkout. The coupon is expiring soon!", 'auto-install-free-ssl' ),
                "<span style='color: red;'>10%",
                "</span>",
                "<strong>'AutoInstall10'</strong>"
            ) ;
            echo  '</p></div>' ;
        }
        
        ?>

          <div class="aifs-pricing">

            <?php 
        $intro_text = __( "Hello", 'auto-install-free-ssl' ) . (( strlen( aifs_admin_first_name() ) > 0 ? " " . aifs_admin_first_name() : "" )) . ", ";
        $intro_text_small = "";
        $ssl_installation = __( "Automatic", 'auto-install-free-ssl' );
        $ssl_installation_more_info = "";
        
        if ( !isset( $app_settings['is_cpanel'] ) || !$app_settings['is_cpanel'] ) {
            $intro_text .= '<span style="color: #77c401;">' . __( "we'll issue you a full refund if we can't automate your SSL certificate.", 'auto-install-free-ssl' ) . ' *</span>';
            //$ssl_installation_more_info = __( "Please contact us after purchase. We'll set up automatic SSL installation either with a bash script or CDN.", 'auto-install-free-ssl');
            $time_required = __( "We'll do it", 'auto-install-free-ssl' );
            $time_required_unlimited_license = __( "We'll do it (10 sites)", 'auto-install-free-ssl' );
            $time_required_more_info_unlimited_license = sprintf( __( "PRO unlimited license is limited to 10 websites. %sIf you can implement the automation with the bash script yourself, it is truly unlimited.", 'auto-install-free-ssl' ), "\n" );
            $wildcard_ssl_single_domain = __( "Yes", 'auto-install-free-ssl' );
            $multisite_support_single_domain = __( "Yes", 'auto-install-free-ssl' );
        } else {
            $intro_text .= sprintf( __( "you have cPanel! %s automation is possible with premium!!", 'auto-install-free-ssl' ), '100%' ) . " ";
            $intro_text .= '<span style="color: #77c401;">' . __( "Otherwise, we'll issue you a full refund.", 'auto-install-free-ssl' ) . '</span>';
            $time_required = __( "1 Min (once)", 'auto-install-free-ssl' );
            $time_required_unlimited_license = __( "1 Min (once)", 'auto-install-free-ssl' );
            $time_required_more_info_unlimited_license = sprintf( __( "If you need the plugin to work on all websites in the same %s, you need %s minutes (once).", 'auto-install-free-ssl' ), ( isset( $app_settings['is_cpanel'] ) && $app_settings['is_cpanel'] ? 'cPanel' : 'hosting' ), ( isset( $app_settings['is_cpanel'] ) && $app_settings['is_cpanel'] ? '9' : '10' ) );
            $wildcard_ssl_single_domain = __( "No", 'auto-install-free-ssl' );
            $multisite_support_single_domain = __( "No", 'auto-install-free-ssl' );
        }
        
        
        if ( !aifs_is_existing_user() ) {
            ?>

                <h1 style="margin: 0 1% -1% 2%; font-size: 1.4em; line-height: 1.5em;"><?php 
            echo  $intro_text ;
            ?></h1>
                <p style="margin-left: 2%;"><?php 
            echo  $intro_text_small ;
            ?></p>
            <?php 
        }
        
        ?>
            <table class="table">
              <!-- Heading -->
              <thead>
                <tr>
                  <th>&nbsp;</th>
                  <th>
                    <?php 
        echo  __( "Free", 'auto-install-free-ssl' ) ;
        ?>
                    <span class="ptable-price"><?php 
        echo  __( "\$0.0", 'auto-install-free-ssl' ) ;
        ?></span>
                  </th>
                  <th class="highlight">
                    <?php 
        echo  __( "Pro", 'auto-install-free-ssl' ) ;
        ?>
                    <span class="ptable-price"><?php 
        echo  __( "\$26.99 / year", 'auto-install-free-ssl' ) ;
        ?></span>
                    <span class="ptable-price">(<?php 
        echo  __( "Lifetime: \$44.99", 'auto-install-free-ssl' ) ;
        ?>)</span>
                  </th>
                  <th>
                    <?php 
        echo  __( "Pro Unlimited", 'auto-install-free-ssl' ) ;
        ?>
                    <span class="ptable-price"><?php 
        echo  __( "\$178.99 / year", 'auto-install-free-ssl' ) ;
        ?></span>
                    <span class="ptable-price">(<?php 
        echo  __( "Lifetime: \$258.99", 'auto-install-free-ssl' ) ;
        ?>)</span>
                  </th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Domain Verification", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "Manual", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Generate SSL", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "Manual", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "SSL Installation", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "Manual", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  $ssl_installation ;
        ?> <!-- <a title="<?php 
        echo  $ssl_installation_more_info ;
        ?>">[?]</a> -->
                  </td>
                  <td>
                    <?php 
        echo  $ssl_installation ;
        ?> <!-- <a title="<?php 
        echo  $ssl_installation_more_info ;
        ?>">[?]</a> -->
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "SSL Renewal", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "Manual", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Automatic", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>

                <?php 
        
        if ( isset( $app_settings['is_cpanel'] ) && $app_settings['is_cpanel'] ) {
            ?>
                    <tr>
                      <td><span class="ptable-title"><?php 
            echo  __( "Cron Job", 'auto-install-free-ssl' ) ;
            ?></span></td>
                      <td>
                        <?php 
            echo  __( "No", 'auto-install-free-ssl' ) ;
            ?>
                      </td>
                      <td>
                        <?php 
            echo  __( "Automatic", 'auto-install-free-ssl' ) ;
            ?> <a title="<?php 
            echo  __( "You don’t need to set up the Cron Job manually. It works by default.", 'auto-install-free-ssl' ) ;
            ?>">[?]</a>
                      </td>
                      <td>
                        <?php 
            echo  __( "Automatic", 'auto-install-free-ssl' ) ;
            ?> <a title="<?php 
            echo  __( "You don’t need to set up the Cron Job manually. It works by default.", 'auto-install-free-ssl' ) ;
            ?>">[?]</a>
                      </td>
                    </tr>
                <?php 
        } else {
            ?>
                    <tr>
                      <td><span class="ptable-title"><?php 
            echo  __( "Automation with Bash script or Cloudflare CDN", 'auto-install-free-ssl' ) ;
            ?></span></td>
                      <td>
                        <?php 
            echo  __( "No", 'auto-install-free-ssl' ) ;
            ?>
                      </td>
                      <td>
                        <?php 
            echo  __( "Yes", 'auto-install-free-ssl' ) ;
            ?> <a title="<?php 
            echo  __( "Please contact us after purchase. After reviewing your web hosting environment, we'll choose the best option (Bash script or Cloudflare CDN) and implement the automation.", 'auto-install-free-ssl' ) ;
            ?>">[?]</a>
                      </td>
                      <td>
                        <?php 
            echo  __( "Yes", 'auto-install-free-ssl' ) ;
            ?> <a title="<?php 
            echo  __( "Please contact us after purchase. After reviewing your web hosting environment, we'll choose the best option (Bash script or Cloudflare CDN) and implement the automation.", 'auto-install-free-ssl' ) ;
            ?>">[?]</a>
                      </td>
                    </tr>
                <?php 
        }
        
        ?>

                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Time Required to Set Up", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "20+ Min (per 60 days)", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  $time_required ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  $time_required_unlimited_license ;
        ?> <a title="<?php 
        echo  $time_required_more_info_unlimited_license ;
        ?>">[?]</a>
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Wildcard SSL", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "No", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  $wildcard_ssl_single_domain ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Yes", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Multisite Support", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "No", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  $multisite_support_single_domain ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "Yes", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>
                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "SSL Expiration Chance", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "High", 'auto-install-free-ssl' ) ;
        ?> <a title="<?php 
        echo  __( "Manually renewing SSL every 60 days is a tiresome job and difficult to remember", 'auto-install-free-ssl' ) ;
        ?>">[?]</a>
                  </td>
                  <td>
                    <?php 
        echo  __( "No", 'auto-install-free-ssl' ) ;
        ?> <!-- <a title="<?php 
        echo  __( "Because renewal is automated", 'auto-install-free-ssl' ) ;
        ?>">[?]</a> -->
                  </td>
                  <td>
                    <?php 
        echo  __( "No", 'auto-install-free-ssl' ) ;
        ?> <!-- <a title="<?php 
        echo  __( "Because renewal is automated", 'auto-install-free-ssl' ) ;
        ?>">[?]</a> -->
                  </td>
                </tr>

                <?php 
        
        if ( isset( $app_settings['is_cpanel'] ) && $app_settings['is_cpanel'] ) {
            ?>
                    <tr>
                      <td><span class="ptable-title"><?php 
            echo  sprintf( __( "One installation works on all websites of a %s", 'auto-install-free-ssl' ), ( isset( $app_settings['is_cpanel'] ) && $app_settings['is_cpanel'] ? "cPanel" : "hosting" ) ) ;
            ?></span></td>
                      <td>
                        <?php 
            echo  __( "No", 'auto-install-free-ssl' ) ;
            ?>
                      </td>
                      <td>
                        <?php 
            echo  __( "No", 'auto-install-free-ssl' ) ;
            ?>
                      </td>
                      <td>
                        <?php 
            echo  __( "Yes", 'auto-install-free-ssl' ) ;
            ?>
                      </td>
                    </tr>
                <?php 
        }
        
        ?>

                <tr>
                  <td><span class="ptable-title"><?php 
        echo  __( "Support", 'auto-install-free-ssl' ) ;
        ?></span></td>
                  <td>
                    <?php 
        echo  __( "Forum", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "E-mail", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                  <td>
                    <?php 
        echo  __( "E-mail / Chat", 'auto-install-free-ssl' ) ;
        ?>
                  </td>
                </tr>
                <!-- Buttons -->
                <?php 
        $free = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_free_plan', 'aifsfree' );
        $pro = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_pro_plan', 'aifspro' );
        $pro_unlimited = wp_nonce_url( get_site_url() . $_SERVER['REQUEST_URI'], 'aifs_pro_unlimited_plan', 'aifsprounlimited' );
        ?>
                <tr>
                  <td>&nbsp;</td>
                  <td class="bg-red"><a class="btn" href="<?php 
        echo  $free ;
        ?>"><?php 
        echo  __( "Select", 'auto-install-free-ssl' ) ;
        ?></a></td>
                  <td class="bg-green"><a class="btn" href="<?php 
        echo  $pro ;
        ?>"><?php 
        echo  __( "Select", 'auto-install-free-ssl' ) ;
        ?></a></td>
                  <td class="bg-lblue"><a class="btn" href="<?php 
        echo  $pro_unlimited ;
        ?>"><?php 
        echo  __( "Select", 'auto-install-free-ssl' ) ;
        ?></a></td>
                </tr>
              </tbody>
            </table>
          </div>

          <?php 
        if ( !isset( $app_settings['is_cpanel'] ) || !$app_settings['is_cpanel'] ) {
            echo  "<br /><br /><p>* <i>" . sprintf( __( "%sTerms & conditions%s apply.", 'auto-install-free-ssl' ), '<a href="https://freessl.tech/terms-of-service" target="_blank">', '</a>' ) . "</i></p>" ;
        }
        ?>

          <!-- <hr />
          <table style="width: 100%; margin-top: 0%;" id="">
            <tr>
                <td class="card block-body" style="width: 50%; padding-left: 1.5%;">
                    <h3 style="text-align: center;"><?php 
        //echo __( "How to set up Automation for Free SSL Certificate [cPanel]", 'auto-install-free-ssl' )
        ?></h3>
                    <p style="color: green; text-align: center;"><?php 
        //echo __( "Video Tutorial of the PRO / UNLIMITED Version [1:42 Minute]", 'auto-install-free-ssl' )
        ?></p>
                    <p style="text-align: center;"><?php 
        //echo __( "Starting from version 3.0.5, you can use the cPanel API Token instead of a password. We'll provide a video: 'How to Create API Tokens in cPanel with a few clicks only'.", 'auto-install-free-ssl' )
        ?></p>

                    <div style="padding:53.33% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/745390051?h=94ba682137&title=0&byline=0&portrait=0" style="position:absolute;top:0;left:0;width:100%;height:100%;" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
                </td>
            </tr>
          </table> -->

      </div>
        <?php 
    }
    
    /**
     * Plan comparison table handler
     *  @since 3.0.6
     */
    public function plan_comparison_table_handler()
    {
        
        if ( isset( $_GET['aifsfree'] ) ) {
            //FREE plan selected
            if ( !wp_verify_nonce( $_GET['aifsfree'], 'aifs_free_plan' ) ) {
                wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
            }
            update_option( 'aifs_free_plan_selected', 1 );
            wp_redirect( admin_url( 'admin.php?page=aifs_generate_ssl_manually' ) );
        } else {
            
            if ( isset( $_GET['aifspro'] ) ) {
                //PRO plan selected
                if ( !wp_verify_nonce( $_GET['aifspro'], 'aifs_pro_plan' ) ) {
                    wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
                }
                update_option( 'aifs_premium_plan_selected', get_option( 'aifs_premium_plan_selected' ) + 1 );
                wp_redirect( admin_url( 'admin.php?page=auto_install_free_ssl-pricing&checkout=true&plan_id=17218&plan_name=pro&billing_cycle=annual&pricing_id=19386&currency=usd' ) );
            } else {
                
                if ( isset( $_GET['aifsprounlimited'] ) ) {
                    //PRO UNLIMITED plan selected
                    if ( !wp_verify_nonce( $_GET['aifsprounlimited'], 'aifs_pro_unlimited_plan' ) ) {
                        wp_die( __( "Access Denied", 'auto-install-free-ssl' ) );
                    }
                    update_option( 'aifs_premium_plan_selected', get_option( 'aifs_premium_plan_selected' ) + 1 );
                    wp_redirect( admin_url( 'admin.php?page=auto_install_free_ssl-pricing&checkout=true&plan_id=17218&plan_name=pro&billing_cycle=annual&pricing_id=19771&currency=usd' ) );
                }
            
            }
        
        }
    
    }
    
    /**
     * Display message after successful payment
     *
     */
    private function after_making_payment()
    {
        ?>
        <div class="wrap">

        <?php 
        echo  aifs_header() ;
        ?>

        <table style="width: 100%; height: 400px; margin-bottom: 2%;">
            <tr>
                <td class="card block-body" style="padding-top: 1%; padding-left: 2%;">
				    <?php 
        $heading = __( "Thank you for the purchase", 'auto-install-free-ssl' );
        $premium_download_link = aifssl_fs()->_get_latest_download_local_url();
        $contact_link = aifssl_fs()->contact_url();
        echo  '<h1 style="text-align: center;">' . $heading . '</h1>' ;
        echo  '<br /><h3 style="color: #076507; text-align: center;">' . __( "Now, please deactivate this FREE version. Then download, install & activate the premium version and enjoy!", 'auto-install-free-ssl' ) . '</h3>' ;
        echo  '<div style="text-align: left; margin-top: 3%; margin-left: 18%;">' ;
        echo  '<p>' . __( "If you missed downloading the Pro version of this plugin, you could download it using any of the following options", 'auto-install-free-ssl' ) . ':</p>' ;
        echo  '<ol>' ;
        echo  '<li><a href="' . $premium_download_link . '">' . __( "Download from this link", 'auto-install-free-ssl' ) . '</a>.</li>' ;
        echo  '<li>' . sprintf( __( "Download from the %s Account page%s.", 'auto-install-free-ssl' ), '<a href="' . admin_url( 'admin.php?page=auto_install_free_ssl-account' ) . '">', '</a>' ) . '</li>' ;
        echo  '<li>' . __( "Download from the email we sent you after the purchase.", 'auto-install-free-ssl' ) . '</li>' ;
        echo  '</ol>' ;
        echo  '</div>' ;
        echo  '<p style="text-align: center;">' . sprintf( __( "The %s License Key%s has been provided in the same email.", 'auto-install-free-ssl' ), '<strong>', '</strong>' ) . '</p>' ;
        echo  '<p style="text-align: center;">' . sprintf( __( "Any issues? %s Contact Us%s right away. We'll be happy to help you.", 'auto-install-free-ssl' ), '<a href="' . $contact_link . '">', '</a>' ) . '</p>' ;
        ?>
                </td>
            </tr>
        </table>

        <?php 
        echo  aifs_powered_by() ;
        ?>
        </div>
    <?php 
    }

}