<?php

/**
 * @package Auto-Install Free SSL
 * This package is a WordPress Plugin. It issues and installs free SSL certificates in cPanel shared hosting with complete automation.
 *
 * @author Free SSL Dot Tech <support@freessl.tech>
 * @copyright  Copyright (C) 2019-2020, Anindya Sundar Mandal
 * @license    http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License, version 3
 * @link       https://freessl.tech
 * @since      Class available since Release 1.0.0
 *
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
namespace AutoInstallFreeSSL\FreeSSLAuto;

use  DateTime ;
use  Exception ;
use  AutoInstallFreeSSL\FreeSSLAuto\Admin\Factory ;
use  AutoInstallFreeSSL\FreeSSLAuto\Admin\HomeOptions ;
class Email
{
    private  $logger ;
    public  $admin_email ;
    public function __construct()
    {
        if ( !defined( 'ABSPATH' ) ) {
            die( __( "Access Denied", 'auto-install-free-ssl' ) );
        }
        $this->logger = new Logger();
        $this->admin_email = get_option( 'admin_email' );
    }
    
    /**
     * @param $admin_first_name
     *
     * @return string
     * 
     *
     *
     * Add review request in automated email notification
     * @since 2.0.0
     */
    public function add_review_request_in_email( $admin_first_name = null )
    {
        $display_review = get_option( 'aifs_display_review' );
        
        if ( $display_review != false && $display_review != 0 ) {
            //If aifs_display_review is set to 1, add the review request
            $html = "<div style='background-color: #000000; padding: 15px; margin-bottom: 18px;'>\n                            <div style='color: #FFFF00; font-size: 1.25em; margin-bottom: 16px;'>\n                                " . __( 'Hey', 'auto-install-free-ssl' ) . ' ' . (( is_null( $admin_first_name ) ? aifs_admin_first_name() : $admin_first_name )) . ', <strong>' . AIFS_NAME . '</strong> ' . __( 'has saved your $$$ by providing Free SSL Certificates and will save more. Could you please do me a BIG favor and give it a 5-star rating on WordPress? To help me spread the word and boost my motivation.', 'auto-install-free-ssl' ) . " <br />~Anindya\n                            </div>\n                            <a style='background: #399642; color: #ffffff; text-decoration: none; padding: 7px 15px; border-radius: 5px;' href='https://wordpress.org/support/plugin/auto-install-free-ssl/reviews/#new-post' target='_blank'>Sure! You Deserve It.</a>\n                      </div>";
        } else {
            $html = "";
        }
        
        return $html;
    }
    
    /**
     * Sends SSL renewal reminder email
     *
     * @throws Exception
     */
    public function send_ssl_renewal_reminder_email()
    {
        $app_settings = aifs_get_app_settings();
        $home = new HomeOptions();
        $certificate = $home->single_domain_get_ssl_file_path();
        
        if ( $certificate ) {
            $cert_array = openssl_x509_parse( openssl_x509_read( file_get_contents( $certificate ) ) );
            $expiry_timestamp = $cert_array['validTo_time_t'];
            //$days_before_expiry_to_renew_ssl = 30;
            //$renewal_timestamp = $expiry_timestamp - ($days_before_expiry_to_renew_ssl * 24 * 60 * 60);
            $now = new DateTime();
            $expiry = new DateTime( '@' . $expiry_timestamp );
            $interval = (int) $now->diff( $expiry )->format( '%R%a' );
            $last_reminder_timestamp = get_option( 'aifs_ssl_renewal_reminder_email_last_sent_timestamp' );
            $interval_from_last_reminder = 0;
            
            if ( $last_reminder_timestamp ) {
                $last_reminder = new \DateTime( '@' . (int) $last_reminder_timestamp );
                $interval_from_last_reminder = (int) $last_reminder->diff( $now )->format( '%R%a' );
            }
            
            
            if ( $interval <= 30 && $interval >= -12 && (!$last_reminder_timestamp || $interval_from_last_reminder >= 15) ) {
                $exp = ( function_exists( 'wp_date' ) ? wp_date( 'F j, Y - h:i:s A', $expiry_timestamp ) : date( 'F j, Y - h:i:s A', $expiry_timestamp ) . " " . __( "UTC", 'auto-install-free-ssl' ) );
                $expiry_date = str_replace( '-', 'at', $exp );
                $issuerShort = $cert_array['issuer']['O'];
                $renew_url = admin_url( "admin.php?page=aifs_generate_ssl_manually" );
                $renew_url = ( strpos( $renew_url, get_site_url() ) !== false ? $renew_url . "#ssl_renewal_form" : get_site_url() . "/wp-admin/admin.php?page=aifs_generate_ssl_manually#ssl_renewal_form" );
                $subject = "Your SSL certificate for " . $cert_array['subject']['CN'] . " ";
                
                if ( $interval > 0 ) {
                    $subject .= sprintf( __( "is expiring in %s days", 'auto-install-free-ssl' ), $interval );
                } else {
                    $subject .= "is EXPIRED! Renew urgently.";
                }
                
                //Email body
                $body = "<html><body><p>Hello " . aifs_admin_first_name() . ",</p>";
                
                if ( $interval > 0 ) {
                    $body .= "<p>" . sprintf( __( "Your SSL certificate for %s will expire in %s days.", 'auto-install-free-ssl' ), str_replace( 'DNS:', '', $cert_array['extensions']['subjectAltName'] ), $interval );
                } else {
                    $body .= "<p>" . sprintf( __( "Your SSL certificate for %s is EXPIRED!", 'auto-install-free-ssl' ), str_replace( 'DNS:', '', $cert_array['extensions']['subjectAltName'] ) );
                }
                
                $body .= " " . sprintf( __( "The expiry date is %s.", 'auto-install-free-ssl' ), $expiry_date ) . "</p>";
                $body .= "<p style='color: red; font-size: 1.3em;'>" . sprintf( __( "If you don't renew the SSL certificate %s, your visitors will see a security warning in red and leave your website.", 'auto-install-free-ssl' ), ( $interval > 0 ? "before the expiry date" : "URGENTLY" ) ) . "</p>";
                $body .= "<p>" . sprintf( __( "Validity of %s free SSL is 90 days. They recommend renewing 30 days before expiry.", 'auto-install-free-ssl' ), $issuerShort ) . "</p>";
                $body .= "<p>" . sprintf( __( "%sClick here%s to Renew your SSL today.", 'auto-install-free-ssl' ), '<a href="' . $renew_url . '">', '</a>' ) . "</p>";
                $body .= "<p>" . sprintf(
                    __( "%sDo you want automatic renewal every 60 days?%s %sClick here%s to upgrade now.", 'auto-install-free-ssl' ),
                    '<strong>',
                    '</strong>',
                    '<a href="' . aifssl_fs()->get_upgrade_url() . '">',
                    '</a>'
                ) . "</p>";
                $body .= "<p>" . __( "Please ignore this email if you have renewed the SSL certificate already.", 'auto-install-free-ssl' ) . "</p>";
                $body .= $this->add_email_signature();
                $body .= "</body></html>";
                //Send email to admin email id and Let's Encrypt registrant email id (provided in basic settings) if both are different
                
                if ( in_array( $this->admin_email, $app_settings['admin_email'] ) ) {
                    $to = implode( ',', $app_settings['admin_email'] );
                } else {
                    $to = $this->admin_email . "," . implode( ',', $app_settings['admin_email'] );
                }
                
                // Set content-type header
                $headers = [];
                $headers[] = 'MIME-Version: 1.0';
                $headers[] = 'Content-type: text/html; charset=iso-8859-1';
                $headers[] = 'From:wordpress@' . aifs_get_domain();
                // Send the email
                
                if ( wp_mail(
                    $to,
                    $subject,
                    $body,
                    $headers
                ) ) {
                    //$email_db[$cert_array['subject']['CN']]['last_sent_timestamp'] = time();
                    update_option( 'aifs_ssl_renewal_reminder_email_last_sent_timestamp', time() );
                    $this->logger->log( __( "SSL renewal reminder email has been sent successfully.", 'auto-install-free-ssl' ) );
                } else {
                    $this->logger->log( __( "Sorry, there was an issue sending the SSL renewal reminder email.", 'auto-install-free-ssl' ) );
                }
            
            }
        
        }
    
    }
    
    /**
     *
     *
     * Add email signature
     * @return string
     *
     * @since 2.0.0
     */
    public function add_email_signature()
    {
        $html = "This is a system generated email from your website.<br />\n        Do not reply to this automated email.<br /><br />\n        --------------<br />\n        Regards,<br />\n        Team <strong>" . AIFS_NAME . "</strong><br />\n        Powered by <a href='https://getwww.me'>GetWWW.me</a> (Beautiful WordPress website design service) and <a href='https://speedify.tech/wordpress-website-speed-optimization-service'>SpeedUpWebsite.info</a> (WordPress website speed optimization service)<br />";
        return $html;
    }

}