<?php
/**
 * The Header: Logo and main menu
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( foodie_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'foodie_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'foodie_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('foodie_action_body_wrap_attributes'); ?>>

		<?php do_action( 'foodie_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'foodie_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('foodie_action_page_wrap_attributes'); ?>>

			<?php do_action( 'foodie_action_page_wrap_start' ); ?>

			<?php
			$foodie_full_post_loading = ( foodie_is_singular( 'post' ) || foodie_is_singular( 'attachment' ) ) && foodie_get_value_gp( 'action' ) == 'full_post_loading';
			$foodie_prev_post_loading = ( foodie_is_singular( 'post' ) || foodie_is_singular( 'attachment' ) ) && foodie_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $foodie_full_post_loading && ! $foodie_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="foodie_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'foodie' ); ?></a>
				<?php if ( foodie_sidebar_present() ) { ?>
				<a class="foodie_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'foodie' ); ?></a>
				<?php } ?>
				<a class="foodie_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'foodie' ); ?></a>

				<?php
				do_action( 'foodie_action_before_header' );

				// Header
				$foodie_header_type = foodie_get_theme_option( 'header_type' );
				if ( 'custom' == $foodie_header_type && ! foodie_is_layouts_available() ) {
					$foodie_header_type = 'default';
				}
				get_template_part( apply_filters( 'foodie_filter_get_template_part', "templates/header-" . sanitize_file_name( $foodie_header_type ) ) );

				// Side menu
				if ( in_array( foodie_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'foodie_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'foodie_action_after_header' );

			}
			?>

			<?php do_action( 'foodie_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( foodie_is_off( foodie_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $foodie_header_type ) ) {
						$foodie_header_type = foodie_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $foodie_header_type && foodie_is_layouts_available() ) {
						$foodie_header_id = foodie_get_custom_header_id();
						if ( $foodie_header_id > 0 ) {
							$foodie_header_meta = foodie_get_custom_layout_meta( $foodie_header_id );
							if ( ! empty( $foodie_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$foodie_footer_type = foodie_get_theme_option( 'footer_type' );
					if ( 'custom' == $foodie_footer_type && foodie_is_layouts_available() ) {
						$foodie_footer_id = foodie_get_custom_footer_id();
						if ( $foodie_footer_id ) {
							$foodie_footer_meta = foodie_get_custom_layout_meta( $foodie_footer_id );
							if ( ! empty( $foodie_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'foodie_action_page_content_wrap_class', $foodie_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'foodie_filter_is_prev_post_loading', $foodie_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( foodie_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'foodie_action_page_content_wrap_data', $foodie_prev_post_loading );
			?>>
				<?php
				do_action( 'foodie_action_page_content_wrap', $foodie_full_post_loading || $foodie_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'foodie_filter_single_post_header', foodie_is_singular( 'post' ) || foodie_is_singular( 'attachment' ) ) ) {
					if ( $foodie_prev_post_loading ) {
						if ( foodie_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'foodie_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$foodie_path = apply_filters( 'foodie_filter_get_template_part', 'templates/single-styles/' . foodie_get_theme_option( 'single_style' ) );
					if ( foodie_get_file_dir( $foodie_path . '.php' ) != '' ) {
						get_template_part( $foodie_path );
					}
				}

				// Widgets area above page
				$foodie_body_style   = foodie_get_theme_option( 'body_style' );
				$foodie_widgets_name = foodie_get_theme_option( 'widgets_above_page' );
				$foodie_show_widgets = ! foodie_is_off( $foodie_widgets_name ) && is_active_sidebar( $foodie_widgets_name );
				if ( $foodie_show_widgets ) {
					if ( 'fullscreen' != $foodie_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					foodie_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $foodie_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'foodie_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $foodie_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'foodie_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'foodie_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="foodie_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( foodie_is_singular( 'post' ) || foodie_is_singular( 'attachment' ) )
							&& $foodie_prev_post_loading 
							&& foodie_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'foodie_action_between_posts' );
						}

						// Widgets area above content
						foodie_create_widgets_area( 'widgets_above_content' );

						do_action( 'foodie_action_page_content_start_text' );
