<?php
/* Booked Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'foodie_booked_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'foodie_booked_theme_setup9', 9 );
	function foodie_booked_theme_setup9() {
		if ( foodie_exists_booked() ) {
			add_action( 'wp_enqueue_scripts', 'foodie_booked_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'foodie_booked_frontend_scripts', 10, 1 );
			add_action( 'wp_enqueue_scripts', 'foodie_booked_frontend_scripts_responsive', 2000 );
			add_action( 'trx_addons_action_load_scripts_front_booked', 'foodie_booked_frontend_scripts_responsive', 10, 1 );
			add_filter( 'foodie_filter_merge_styles', 'foodie_booked_merge_styles' );
			add_filter( 'foodie_filter_merge_styles_responsive', 'foodie_booked_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'foodie_filter_tgmpa_required_plugins', 'foodie_booked_tgmpa_required_plugins' );
			add_filter( 'foodie_filter_theme_plugins', 'foodie_booked_theme_plugins' );
		}
	}
}


// Filter to add in the required plugins list
if ( ! function_exists( 'foodie_booked_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('foodie_filter_tgmpa_required_plugins',	'foodie_booked_tgmpa_required_plugins');
	function foodie_booked_tgmpa_required_plugins( $list = array() ) {
		if ( foodie_storage_isset( 'required_plugins', 'booked' ) && foodie_storage_get_array( 'required_plugins', 'booked', 'install' ) !== false && foodie_is_theme_activated() ) {
			$path = foodie_get_plugin_source_path( 'plugins/booked/booked.zip' );
			if ( ! empty( $path ) || foodie_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => foodie_storage_get_array( 'required_plugins', 'booked', 'title' ),
					'slug'     => 'booked',
					'source'   => ! empty( $path ) ? $path : 'upload://booked.zip',
					'version'  => '2.3',
					'required' => false,
				);
			}
		}
		return $list;
	}
}


// Filter theme-supported plugins list
if ( ! function_exists( 'foodie_booked_theme_plugins' ) ) {
	//Handler of the add_filter( 'foodie_filter_theme_plugins', 'foodie_booked_theme_plugins' );
	function foodie_booked_theme_plugins( $list = array() ) {
		return foodie_add_group_and_logo_to_slave( $list, 'booked', 'booked-' );
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'foodie_exists_booked' ) ) {
	function foodie_exists_booked() {
		return class_exists( 'booked_plugin' );
	}
}


// Return a relative path to the plugin styles depend the version
if ( ! function_exists( 'foodie_booked_get_styles_dir' ) ) {
	function foodie_booked_get_styles_dir( $file ) {
		$base_dir = 'plugins/booked/';
		return $base_dir
				. ( defined( 'BOOKED_VERSION' ) && version_compare( BOOKED_VERSION, '2.4', '<' ) && foodie_get_folder_dir( $base_dir . 'old' )
					? 'old/'
					: ''
					)
				. $file;
	}
}


// Enqueue styles for frontend
if ( ! function_exists( 'foodie_booked_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'foodie_booked_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'foodie_booked_frontend_scripts', 10, 1 );
	function foodie_booked_frontend_scripts( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && foodie_need_frontend_scripts( 'booked' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$foodie_url = foodie_get_file_url( foodie_booked_get_styles_dir( 'booked.css' ) );
			if ( '' != $foodie_url ) {
				wp_enqueue_style( 'foodie-booked', $foodie_url, array(), null );
			}
		}
	}
}


// Enqueue responsive styles for frontend
if ( ! function_exists( 'foodie_booked_frontend_scripts_responsive' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'foodie_booked_frontend_scripts_responsive', 2000 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_booked', 'foodie_booked_frontend_scripts_responsive', 10, 1 );
	function foodie_booked_frontend_scripts_responsive( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && foodie_need_frontend_scripts( 'booked' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$foodie_url = foodie_get_file_url( foodie_booked_get_styles_dir( 'booked-responsive.css' ) );
			if ( '' != $foodie_url ) {
				wp_enqueue_style( 'foodie-booked-responsive', $foodie_url, array(), null, foodie_media_for_load_css_responsive( 'booked' ) );
			}
		}
	}
}


// Merge custom styles
if ( ! function_exists( 'foodie_booked_merge_styles' ) ) {
	//Handler of the add_filter('foodie_filter_merge_styles', 'foodie_booked_merge_styles');
	function foodie_booked_merge_styles( $list ) {
		$list[ foodie_booked_get_styles_dir( 'booked.css' ) ] = false;
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'foodie_booked_merge_styles_responsive' ) ) {
	//Handler of the add_filter('foodie_filter_merge_styles_responsive', 'foodie_booked_merge_styles_responsive');
	function foodie_booked_merge_styles_responsive( $list ) {
		$list[ foodie_booked_get_styles_dir( 'booked-responsive.css' ) ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( foodie_exists_booked() ) {
	require_once foodie_get_file_dir( foodie_booked_get_styles_dir( 'booked-style.php' ) );
}
