<?php
/**
 * Required plugins
 *
 * @package FOODIE
 * @since FOODIE 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$foodie_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'foodie' ),
	'page_builders' => esc_html__( 'Page Builders', 'foodie' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'foodie' ),
	'socials'       => esc_html__( 'Socials and Communities', 'foodie' ),
	'events'        => esc_html__( 'Events and Appointments', 'foodie' ),
	'content'       => esc_html__( 'Content', 'foodie' ),
	'other'         => esc_html__( 'Other', 'foodie' ),
);
$foodie_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'foodie' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'foodie' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $foodie_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'foodie' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'foodie' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $foodie_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'foodie' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'foodie' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $foodie_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'foodie' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'foodie' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $foodie_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'foodie' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'foodie' ),
		'required'    => false,
        'install'     => false,
		'logo'        => 'woocommerce.png',
		'group'       => $foodie_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'foodie' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'foodie' ),
		'required'    => false,
        'install'     => false,
		'logo'        => 'elegro-payment.png',
		'group'       => $foodie_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'foodie' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'foodie' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $foodie_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'foodie' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'foodie' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $foodie_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $foodie_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $foodie_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'foodie' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'foodie' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => foodie_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $foodie_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'foodie' ),
		'description' => '',
		'required'    => false,
		'logo'        => foodie_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => foodie_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => foodie_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $foodie_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'foodie' ),
		'description' => '',
		'required'    => false,
        'install'     => false,
		'logo'        => foodie_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'foodie' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'foodie' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'foodie' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'foodie' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $foodie_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'foodie' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'foodie' ),
		'required'    => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $foodie_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'foodie' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'foodie' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $foodie_theme_required_plugins_groups['other'],
	),
);

if ( FOODIE_THEME_FREE ) {
	unset( $foodie_theme_required_plugins['js_composer'] );
	unset( $foodie_theme_required_plugins['booked'] );
	unset( $foodie_theme_required_plugins['the-events-calendar'] );
	unset( $foodie_theme_required_plugins['calculated-fields-form'] );
	unset( $foodie_theme_required_plugins['essential-grid'] );
	unset( $foodie_theme_required_plugins['revslider'] );
	unset( $foodie_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $foodie_theme_required_plugins['trx_updater'] );
	unset( $foodie_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
foodie_storage_set( 'required_plugins', $foodie_theme_required_plugins );
