<?php
/**
 * The template to display default site footer
 *
 * @package FOODIE
 * @since FOODIE 1.0.10
 */

$foodie_footer_id = foodie_get_custom_footer_id();
$foodie_footer_meta = get_post_meta( $foodie_footer_id, 'trx_addons_options', true );
if ( ! empty( $foodie_footer_meta['margin'] ) ) {
	foodie_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( foodie_prepare_css_value( $foodie_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $foodie_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $foodie_footer_id ) ) ); ?>
						<?php
						$foodie_footer_scheme = foodie_get_theme_option( 'footer_scheme' );
						if ( ! empty( $foodie_footer_scheme ) && ! foodie_is_inherit( $foodie_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $foodie_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'foodie_action_show_layout', $foodie_footer_id );
	?>
</footer><!-- /.footer_wrap -->
