<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package FOODIE
 * @since FOODIE 1.0.10
 */

// Footer sidebar
$foodie_footer_name    = foodie_get_theme_option( 'footer_widgets' );
$foodie_footer_present = ! foodie_is_off( $foodie_footer_name ) && is_active_sidebar( $foodie_footer_name );
if ( $foodie_footer_present ) {
	foodie_storage_set( 'current_sidebar', 'footer' );
	$foodie_footer_wide = foodie_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $foodie_footer_name ) ) {
		dynamic_sidebar( $foodie_footer_name );
	}
	$foodie_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $foodie_out ) ) {
		$foodie_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $foodie_out );
		$foodie_need_columns = true;   //or check: strpos($foodie_out, 'columns_wrap')===false;
		if ( $foodie_need_columns ) {
			$foodie_columns = max( 0, (int) foodie_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $foodie_columns ) {
				$foodie_columns = min( 4, max( 1, foodie_tags_count( $foodie_out, 'aside' ) ) );
			}
			if ( $foodie_columns > 1 ) {
				$foodie_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $foodie_columns ) . ' widget', $foodie_out );
			} else {
				$foodie_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $foodie_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'foodie_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $foodie_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $foodie_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'foodie_action_before_sidebar', 'footer' );
				foodie_show_layout( $foodie_out );
				do_action( 'foodie_action_after_sidebar', 'footer' );
				if ( $foodie_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $foodie_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'foodie_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
