<?php
/**
 * The template to display Admin notices
 *
 * @package FOODIE
 * @since FOODIE 1.0.1
 */

$foodie_theme_slug = get_option( 'template' );
$foodie_theme_obj  = wp_get_theme( $foodie_theme_slug );
?>
<div class="foodie_admin_notice foodie_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$foodie_theme_img = foodie_get_file_url( 'screenshot.jpg' );
	if ( '' != $foodie_theme_img ) {
		?>
		<div class="foodie_notice_image"><img src="<?php echo esc_url( $foodie_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'foodie' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="foodie_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'foodie' ),
				$foodie_theme_obj->get( 'Name' ) . ( FOODIE_THEME_FREE ? ' ' . __( 'Free', 'foodie' ) : '' ),
				$foodie_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="foodie_notice_text">
		<p class="foodie_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $foodie_theme_obj->description ) );
			?>
		</p>
		<p class="foodie_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'foodie' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="foodie_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=foodie_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'foodie' );
			?>
		</a>
	</div>
</div>
