<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FOODIE
 * @since FOODIE 1.71.0
 */

$foodie_template_args = get_query_var( 'foodie_template_args' );

$foodie_columns       = 1;

$foodie_expanded      = ! foodie_sidebar_present() && foodie_get_theme_option( 'expand_content' ) == 'expand';

$foodie_post_format   = get_post_format();
$foodie_post_format   = empty( $foodie_post_format ) ? 'standard' : str_replace( 'post-format-', '', $foodie_post_format );

if ( is_array( $foodie_template_args ) ) {
	$foodie_columns    = empty( $foodie_template_args['columns'] ) ? 1 : max( 1, $foodie_template_args['columns'] );
	$foodie_blog_style = array( $foodie_template_args['type'], $foodie_columns );
	if ( ! empty( $foodie_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $foodie_columns > 1 ) {
	    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns, ! empty( $foodie_template_args['columns_tablet']) ? $foodie_template_args['columns_tablet'] : '', ! empty($foodie_template_args['columns_mobile']) ? $foodie_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $foodie_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $foodie_post_format ) );
	foodie_add_blog_animation( $foodie_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$foodie_hover      = ! empty( $foodie_template_args['hover'] ) && ! foodie_is_inherit( $foodie_template_args['hover'] )
							? $foodie_template_args['hover']
							: foodie_get_theme_option( 'image_hover' );
	$foodie_components = ! empty( $foodie_template_args['meta_parts'] )
							? ( is_array( $foodie_template_args['meta_parts'] )
								? $foodie_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $foodie_template_args['meta_parts'] ) )
								)
							: foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) );
	foodie_show_post_featured( apply_filters( 'foodie_filter_args_featured',
		array(
			'no_links'   => ! empty( $foodie_template_args['no_links'] ),
			'hover'      => $foodie_hover,
			'meta_parts' => $foodie_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $foodie_template_args['thumb_size'] )
								? $foodie_template_args['thumb_size']
								: foodie_get_thumb_size( 
								in_array( $foodie_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $foodie_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$foodie_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$foodie_show_title = get_the_title() != '';
		$foodie_show_meta  = count( $foodie_components ) > 0 && ! in_array( $foodie_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $foodie_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'foodie_filter_show_blog_categories', $foodie_show_meta && in_array( 'categories', $foodie_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'foodie_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						foodie_show_post_meta( apply_filters(
															'foodie_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $foodie_hover, 1
															)
											);
						?>
					</div>
					<?php
					$foodie_components = foodie_array_delete_by_value( $foodie_components, 'categories' );
					do_action( 'foodie_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'foodie_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'foodie_action_before_post_title' );
					if ( empty( $foodie_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'foodie_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $foodie_template_args['excerpt_length'] ) && ! in_array( $foodie_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$foodie_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'foodie_filter_show_blog_excerpt', empty( $foodie_template_args['hide_excerpt'] ) && foodie_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				foodie_show_post_content( $foodie_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'foodie_filter_show_blog_meta', $foodie_show_meta, $foodie_components, 'band' ) ) {
			if ( count( $foodie_components ) > 0 ) {
				do_action( 'foodie_action_before_post_meta' );
				foodie_show_post_meta(
					apply_filters(
						'foodie_filter_post_meta_args', array(
							'components' => join( ',', $foodie_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'foodie_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'foodie_filter_show_blog_readmore', ! $foodie_show_title || ! empty( $foodie_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $foodie_template_args['no_links'] ) ) {
				do_action( 'foodie_action_before_post_readmore' );
				foodie_show_post_more_link( $foodie_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'foodie_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $foodie_template_args ) ) {
	if ( ! empty( $foodie_template_args['slider'] ) || $foodie_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
