<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

$foodie_template_args = get_query_var( 'foodie_template_args' );
if ( is_array( $foodie_template_args ) ) {
	$foodie_columns    = empty( $foodie_template_args['columns'] ) ? 2 : max( 1, $foodie_template_args['columns'] );
	$foodie_blog_style = array( $foodie_template_args['type'], $foodie_columns );
    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns, ! empty( $foodie_template_args['columns_tablet']) ? $foodie_template_args['columns_tablet'] : '', ! empty($foodie_template_args['columns_mobile']) ? $foodie_template_args['columns_mobile'] : '' );
} else {
	$foodie_blog_style = explode( '_', foodie_get_theme_option( 'blog_style' ) );
	$foodie_columns    = empty( $foodie_blog_style[1] ) ? 2 : max( 1, $foodie_blog_style[1] );
    $foodie_columns_class = foodie_get_column_class( 1, $foodie_columns );
}

$foodie_post_format = get_post_format();
$foodie_post_format = empty( $foodie_post_format ) ? 'standard' : str_replace( 'post-format-', '', $foodie_post_format );

?><div class="
<?php
if ( ! empty( $foodie_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( foodie_is_blog_style_use_masonry( $foodie_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $foodie_columns ) : esc_attr( $foodie_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $foodie_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $foodie_columns )
		. ( 'portfolio' != $foodie_blog_style[0] ? ' ' . esc_attr( $foodie_blog_style[0] )  . '_' . esc_attr( $foodie_columns ) : '' )
	);
	foodie_add_blog_animation( $foodie_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$foodie_hover   = ! empty( $foodie_template_args['hover'] ) && ! foodie_is_inherit( $foodie_template_args['hover'] )
								? $foodie_template_args['hover']
								: foodie_get_theme_option( 'image_hover' );

	if ( 'dots' == $foodie_hover ) {
		$foodie_post_link = empty( $foodie_template_args['no_links'] )
								? ( ! empty( $foodie_template_args['link'] )
									? $foodie_template_args['link']
									: get_permalink()
									)
								: '';
		$foodie_target    = ! empty( $foodie_post_link ) && false === strpos( $foodie_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$foodie_components = ! empty( $foodie_template_args['meta_parts'] )
							? ( is_array( $foodie_template_args['meta_parts'] )
								? $foodie_template_args['meta_parts']
								: explode( ',', $foodie_template_args['meta_parts'] )
								)
							: foodie_array_get_keys_by_value( foodie_get_theme_option( 'meta_parts' ) );

	// Featured image
	foodie_show_post_featured( apply_filters( 'foodie_filter_args_featured',
        array(
			'hover'         => $foodie_hover,
			'no_links'      => ! empty( $foodie_template_args['no_links'] ),
			'thumb_size'    => ! empty( $foodie_template_args['thumb_size'] )
								? $foodie_template_args['thumb_size']
								: foodie_get_thumb_size(
									foodie_is_blog_style_use_masonry( $foodie_blog_style[0] )
										? (	strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false || $foodie_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( foodie_get_theme_option( 'body_style' ), 'full' ) !== false || $foodie_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => foodie_is_blog_style_use_masonry( $foodie_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $foodie_components,
			'class'         => 'dots' == $foodie_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $foodie_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $foodie_post_link )
												? '<a href="' . esc_url( $foodie_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $foodie_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $foodie_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $foodie_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!