<?php
/**
 * The template to display the widgets area in the header
 *
 * @package FOODIE
 * @since FOODIE 1.0
 */

// Header sidebar
$foodie_header_name    = foodie_get_theme_option( 'header_widgets' );
$foodie_header_present = ! foodie_is_off( $foodie_header_name ) && is_active_sidebar( $foodie_header_name );
if ( $foodie_header_present ) {
	foodie_storage_set( 'current_sidebar', 'header' );
	$foodie_header_wide = foodie_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $foodie_header_name ) ) {
		dynamic_sidebar( $foodie_header_name );
	}
	$foodie_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $foodie_widgets_output ) ) {
		$foodie_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $foodie_widgets_output );
		$foodie_need_columns   = strpos( $foodie_widgets_output, 'columns_wrap' ) === false;
		if ( $foodie_need_columns ) {
			$foodie_columns = max( 0, (int) foodie_get_theme_option( 'header_columns' ) );
			if ( 0 == $foodie_columns ) {
				$foodie_columns = min( 6, max( 1, foodie_tags_count( $foodie_widgets_output, 'aside' ) ) );
			}
			if ( $foodie_columns > 1 ) {
				$foodie_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $foodie_columns ) . ' widget', $foodie_widgets_output );
			} else {
				$foodie_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $foodie_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'foodie_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $foodie_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $foodie_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'foodie_action_before_sidebar', 'header' );
				foodie_show_layout( $foodie_widgets_output );
				do_action( 'foodie_action_after_sidebar', 'header' );
				if ( $foodie_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $foodie_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'foodie_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
